<?php
/*
    Copyright (C) 2017 DashingDB (http://www.dashingdb.com

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

include("conf.php");
include("define.php");
$GLOBALS['my_con'] = "";
mysql_db_connect();
mysql_create_table();
mysql_create_fields();

function mysql_db_connect()
{
	$dashingdb_conn = new mysqli($GLOBALS['db_host'], $GLOBALS['db_user'], $GLOBALS['db_pass'], $GLOBALS['db_name']);
	
	if ($dashingdb_conn->connect_error) {
		die("DashingDB Connection Failed: " . $dashingdb_conn->connect_error);
	}
	
	$GLOBALS['my_con'] = $dashingdb_conn;
}

function mysql_create_table()
{
	$db = $GLOBALS['my_con'];
	$my_tables = explode(",", trim($GLOBALS['tables']));
	
	foreach($my_tables as $value)
	{
		if(!$db->query('CREATE TABLE IF NOT EXISTS `' . $value . '` (`main_id` INT NOT NULL PRIMARY KEY AUTO_INCREMENT, `input_date` TEXT)'))
		{
			die("DashingDB Create Table Failed: " . $db->error);
		}
	}
}

function mysql_create_fields()
{
	$db = $GLOBALS['my_con'];
	
	foreach($GLOBALS['fields'] as $table=>$fName)
	{
		$my_fields = explode(",", trim($fName));
		
		foreach($my_fields as $fieldname)
		{
			if ($fieldname == "") continue;
			
			$result = $db->query("SHOW COLUMNS FROM `" . $table . "` LIKE '$fieldname'");
			$exists = (mysqli_num_rows($result))?TRUE:FALSE;
			
			if(!$exists)
			{
				if(!$db->query('ALTER TABLE `' . $table .'` ADD `' . $fieldname . '` TEXT'))
				{
					die("DashingDB Create Field Failed: " . $db->error);
				}
			}
		}
	}
}

function mysql_insert_row($table, $row, $unique)
{
	$db = $GLOBALS['my_con'];
	
	$item_name = "";
	$item_value = "";
	
	foreach($row as $key=>$value)
	{
		$field_name = mysql_name_to_field($table, $key);
		
		if ($field_name == "0")
		{
			echo "Error: No table (" . $table . ") or field (" . $key . ") exists.";
			exit;
		}
		
		$value = mysqli_real_escape_string($db, $value);
	
		$item_name .=  "`" . $field_name . "` , ";
		$item_value .=  "'" . $value . "' , ";
	}
	
	if (mysql_check_unique($table, $row, $unique) == "0")
	{
		return "NOT UNIQUE";
	}
	
	$time_stamp = time();
	
	if(!$db->query("INSERT INTO `" . $table . "` (" . $item_name . "`input_date`) 
	VALUES (" . $item_value . " '" . $time_stamp . "')"))
	{
		die("DashingDB Insert Row Failed: " . $db->error);
	}
	
	return $db->insert_id;
}

function mysql_name_to_field($table, $name)
{
	if (!isset($GLOBALS['fields'][$table])) $GLOBALS['fields'][$table] = "";
	$my_fields = explode(",", trim($GLOBALS['fields'][$table] ));
	
	$i = 0;
	foreach($my_fields as $value)
	{
		if ($value == $name) return $name;
	}
	
	return "0";
}

function mysql_check_unique($table, $row, $unique)
{
	$db = $GLOBALS['my_con'];
	
	if(is_array($unique))
	{
		$q_data = "";
		foreach($unique as $value)
		{
			$fieldname = mysql_name_to_field($table, $value);
			
			if(!isset($row[$value]))
			{
				echo "Error: No value of field (".$value.") found.";
				exit;
			}
			
			$q_data .= " AND " . $fieldname . "='" . $row[$value] . "'";
		}
		
		$result = $db->query("SELECT * FROM `" . $table . "` WHERE main_id != ''" . $q_data);
		$num = mysqli_num_rows($result);
		
		if($num > 0)
		{
			return "0";	
		}
	}
}

function mysql_delete_row($table, $condition)
{
	$db = $GLOBALS['my_con'];
	
	$q_data = "";
	foreach($condition as $key=>$value)
	{
		if($key == "main_id" || $key == "input_date")
		{
			$field_name = $key;
		}
		else
		{
			$field_name = mysql_name_to_field($table, $key);
		
			if ($field_name == "0")
			{
				echo "Error: No table (" . $table . ") or field (" . $key . ") exists.";
				exit;
			}
		}
		
		$q_data .= mysql_convert_equals($field_name, $value);
	}
	
	if(!$db->query("DELETE FROM `" . $table . "` WHERE main_id!=''" . $q_data) )
	{
		die("DashingDB Delete Row Failed: " . $db->error);
	}
}

function mysql_convert_equals($field_name, $condition)
{
	$db = $GLOBALS['my_con'];
	
	$q_data = "";
	foreach($condition as $key=>$value)
	{		
		$value = mysqli_real_escape_string($db, $value);
		
		if($key == "eq") $midSign = " = ";	
		elseif($key == "neq") $midSign = " != ";
		elseif($key == "gr") $midSign = " > ";
		elseif($key == "sm") $midSign = " < ";	
		elseif($key == "gre") $midSign = " >= ";	
		elseif($key == "sme") $midSign = " <= ";
		elseif($key == "li") $midSign = " LIKE ";	
		elseif($key == "nli") $midSign = " NOT LIKE ";		
		elseif($key == "lip") $midSign = "lip";
		elseif($key == "libp") $midSign = "libp";	
		elseif($key == "liap") $midSign = "liap";
		elseif($key == "nlip") $midSign = "nlip";
		elseif($key == "nlibp") $midSign = "nlibp";
		elseif($key == "nliap") $midSign = "nliap";
		elseif($key == "regex")	$midSign = " REGEXP ";
		elseif($key == "nregex") $midSign = " NOT REGEXP ";	
		elseif($key == "in") $midSign = " IN ";	
		elseif($key == "nin") $midSign = " NOT IN ";
		
		if ($midSign == "lip") $q_data .= " AND " . $field_name . " LIKE '%" . $value . "%'";	
		else if ($midSign == "libp") $q_data .= " AND " . $field_name . " LIKE '%" . $value . "'";	
		else if ($midSign == "liap") $q_data .= " AND " . $field_name . " LIKE '" . $value . "%'";	
		elseif ($midSign == "nlip") $q_data .= " AND " . $field_name . " NOT LIKE '%" . $value . "%'";	
		else if ($midSign == "nlibp") $q_data .= " AND " . $field_name . " NOT LIKE '%" . $value . "'";	
		else if ($midSign == "nliap") $q_data .= " AND " . $field_name . " NOT LIKE '" . $value . "%'";		
		else if ($midSign == "IN") $q_data .= " AND " . $field_name . " IN (" . $value . ")";	
		else if ($midSign == "NOT IN") $q_data .= " AND " . $field_name . " NOT IN (" . $value . ")";	
		else $q_data .= " AND " . $field_name . $midSign . "'" . $value . "'";	
	}
	
	return $q_data;
}

function mysql_show_row($table, $condition, $split, $asc)
{
	$db = $GLOBALS['my_con'];
	
	$q_data = "";
	if (is_array($condition))
	{
		foreach($condition as $key=>$value)
		{
			if($key == "main_id" || $key == "input_date")
			{
				$field_name = $key;
			}
			else
			{
				$field_name = mysql_name_to_field($table, $key);
		
				if ($field_name == "0")
				{
					echo "Error: No table (" . $table . ") or field (" . $key . ") exists.";
					exit;
				}
			}
		
			$q_data .= mysql_convert_equals($field_name, $value);
		}
	}
	
	if (strpos($asc, '=') !== false) 
	{
		$asc_split = explode("=", $asc);
		
		$field_name = mysql_name_to_field($table, trim($asc_split[0]));
		
		if ($field_name == "0")
		{
			echo "Error: No table (" . $table . ") or field (" . $asc_split[0] . ") exists.";
			exit;
		}
		
		if(trim($asc_split[1]) == "true")
		{
			$arraned = " ORDER BY " . $field_name . " ASC";
		}
		else
		{
			$arraned = " ORDER BY " . $field_name . " DESC";
		}
	}
	else
	{
		if ($asc == "true")
		{
			$arraned = " ORDER BY main_id ASC";
		}
		else
		{
			$arraned = " ORDER BY main_id DESC";
		}
	}
	
	
	if (is_array($split))
	{
		if (!(isset($split["page"]))) 
 		{ 
 			$pagenum = 1; 
		} 
		else
		{
			$pagenum = $split["page"];
		}
		
		$split_rows_count = mysql_count_rows($table, $condition); 
		$page_rows = $split["rpg"];
		
		$last = ceil($split_rows_count/$page_rows); 

 		if ($pagenum < 1) 
 		{ 
 			$pagenum = 1; 
		} 
 		elseif ($pagenum > $last) 
 		{ 
 			$pagenum = $last; 
 		}
		
		if($pagenum == 0) $pagenum = 1; 
		
		$max = ' limit ' .($pagenum - 1) * $page_rows .',' .$page_rows; 
		
		$result = $db->query("SELECT * FROM `" . $table . "` WHERE main_id!=''" . $q_data . $arraned . $max);
	}
	else
	{
		$result = $db->query("SELECT * FROM `" . $table . "` WHERE main_id!=''" . $q_data . $arraned);
	}
	
	if(!$result)
	{
		die("DashingDB Show Rows Failed: " . $db->error);
	}
	
	$mergingData = array();
	while($rows = mysqli_fetch_array($result))
	{
		array_push($mergingData, $rows);
	}
	
	return $mergingData;
}

function mysql_count_rows($table, $condition)
{
	$db = $GLOBALS['my_con'];
	
	$q_data = "";
	foreach($condition as $key=>$value)
	{
		if($key == "main_id" || $key == "input_date")
		{
			$field_name = $key;
		}
		else
		{
			$field_name = mysql_name_to_field($table, $key);
		
			if ($field_name == "0")
			{
				echo "Error: No table (" . $table . ") or field (" . $key . ") exists.";
				exit;
			}
		}
		
		$q_data .= mysql_convert_equals($field_name, $value);
	}
	
	$result = $db->query("SELECT * FROM `" . $table . "` WHERE main_id!=''" . $q_data);
	
	if(!$result)
	{
		die("DashingDB Count Rows Failed: " . $db->error);
	}

	$num = mysqli_num_rows($result);
	
	return $num;
}

function mysql_update_row($table, $update ,$condition)
{
	$db = $GLOBALS['my_con'];
	
	$q_data = "";
	foreach($condition as $key=>$value)
	{
		if($key == "main_id" || $key == "input_date")
		{
			$field_name = $key;
		}
		else
		{
			$field_name = mysql_name_to_field($table, $key);
		
			if ($field_name == "0")
			{
				echo "Error: No table (" . $table . ") or field (" . $key . ") exists.";
				exit;
			}
		}
		
		$q_data .= mysql_convert_equals($field_name, $value);
	}
	
	foreach($update as $key=>$value)
	{
		$value = mysqli_real_escape_string($db, $value);
		
		$field_name = mysql_name_to_field($table, $key);
		
		if ($field_name == "0")
		{
			echo "Error: No table (" . $table . ") or field (" . $key . ") exists.";
			exit;
		}
	
		if(!$db->query("UPDATE `" . $table . "` SET " . $field_name . "='" . $value . "' WHERE main_id!=''" . $q_data))
		{
			die("DashingDB Update Row Failed: " . $db->error);
		}
	}
}

function mysql_split_count_rows($table, $condition, $split)
{
	$db = $GLOBALS['my_con'];
	
	$q_data = "";
	foreach($condition as $key=>$value)
	{
		if($key == "main_id" || $key == "input_date")
		{
			$field_name = $key;
		}
		else
		{
			$field_name = mysql_name_to_field($table, $key);
		
			if ($field_name == "0")
			{
				echo "Error: No table (" . $table . ") or field (" . $key . ") exists.";
				exit;
			}
		}
		
		$q_data .= mysql_convert_equals($field_name, $value);
	}
	
	
	if (!(isset($split["page"]))) 
 	{ 
 		$pagenum = 1; 
	} 
	else
	{
		$pagenum = $split["page"];
	}
	
 	$split_rows_count = mysql_count_rows($table, $condition); 
	$page_rows = $split["rpg"]; 
	
	$last = ceil($split_rows_count/$page_rows); 

	if ($pagenum < 1) 
	{ 
		$pagenum = 1; 
	} 
	elseif ($pagenum > $last) 
	{ 
		$pagenum = $last; 
	}	 
		
	$max = ' limit ' .($pagenum - 1) * $page_rows .',' .$page_rows; 
	
	$result = $db->query("SELECT * FROM `" . $table . "` WHERE main_id!=''" . $q_data . $max);
	
	if(!$result)
	{
		die("DashingDB Split Count Rows Failed: " . $db->error);
	}

	$num = mysqli_num_rows($result);
	
	return $num;
}

function mysql_split_total_pages($table, $condition, $split)
{
	$q_data = "";
	foreach($condition as $key=>$value)
	{
		if($key == "main_id" || $key == "input_date")
		{
			$field_name = $key;
		}
		else
		{
			$field_name = mysql_name_to_field($table, $key);
		
			if ($field_name == "0")
			{
				echo "Error: No table (" . $table . ") or field (" . $key . ") exists.";
				exit;
			}
		}
		
		$q_data .= mysql_convert_equals($field_name, $value);
	}
	
 	$split_rows_count = mysql_count_rows($table, $condition); 

	$page_rows = $split["rpg"]; 
	
	$last = ceil($split_rows_count/$page_rows);
	
	return $last; 
}

?>